package com.hero.ui.dialog;

import java.awt.GridBagConstraints;
import java.awt.Insets;

import javax.swing.JLabel;
import javax.swing.JPanel;

import com.hero.objects.talents.DangerSense;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class DangerSenseDialog extends GenericDialog {
	private static final long serialVersionUID = -7398776888338241690L;

	protected DangerSense skill;

	private JLabel rollLbl;

	public DangerSenseDialog(DangerSense skill, boolean isNew, boolean isPower) {
		super(skill, isNew, isPower);
		this.skill = skill;
		init();
		if (pointsLbl != null) {
			pointsLbl.setVisible(false);
		}
		if (pointsTF != null) {
			pointsTF.setVisible(false);
		}
	}

	@Override
	protected JPanel getTopPanel() {
		JPanel panel = super.getTopPanel();
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 50;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(5, 5, 5, 5);
		gbc.gridx = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 0;
		gbc.gridy = 70;
		gbc.gridx = 2;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 1;
		if (skill.getRoll().trim().length() > 0) {
			panel.add(rollLbl, gbc);
		}
		gbc.gridy = 80;
		gbc.gridx = 1;
		gbc.weightx = 1;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weighty = 0;
		gbc.weightx = 0;
		return panel;
	}

	@Override
	protected void initListeners() {
		super.initListeners();
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		rollLbl = new JLabel("Roll:");
		levelTF.setEnabled(true);
		levelsLbl.setEnabled(true);

		updateValues();
	}

	@Override
	public void updateValues() {
		rollLbl.setText(skill.getRoll());
		super.updateValues();
	}
}